package w83a.w83aBeans;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aDAO.w83aConstantesBD.W83aDelegadosBD;
import w83a.w83aDAO.w83aConstantesBD.W83aDelegadosIncidenciasVistaBD;
import w83a.w83aDAO.w83aConstantesBD.W83aSindicatosBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;


/*
 * @author jrgil 
 */
public class W83aDelegadosBean extends W83aBaseBean implements W83aBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	private String	actaTerritorio = "";
	private String	actaAnyo = "";
	private String	actaNum = "";
	private String	actaVersion = "";
	private String	codColegio = "";
	private String	codColegioLetra = "";
	private String	colegio_cast = "";
	private String	colegio_eusk = "";
	private String	dniDelegado = "";
	private String	primerApellidoDelegado = "";
	private String	segundoApellidoDelegado = "";
	private String	nombreDelegado = "";
	private String	sexoDelegado = "";
	private String	codSindicato = "";
	private String	desSindicato = "";
	private String	sindicato_cast = "";
	private String	sindicato_eusk = "";
	private String	siglas = "";
	private String	fechaAlta = "";
	private String	fechaBaja = "";
	private String	codBaja = "";
	private String	baja_cast = "";
	private String	baja_Eusk = "";
	private String	dniSustituto = "";
	private String	dniSustituido = "";
	private String	fActu = "";
	private String	usuario = "";
	
	
	
   public String getCodColegioLetra() {
		return codColegioLetra;
	}

	public void setCodColegioLetra(String codColegioLetra) {
		this.codColegioLetra = codColegioLetra;
	}

public String getSiglas() {
		return siglas;
	}

	public void setSiglas(String siglas) {
		this.siglas = siglas;
	}

public String getBajaImg(){
	   if(StringUtils.isNotEmpty(this.fechaBaja)){
		   return "<img src='"+Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_RIA")+"/images/botones/cancelar.png'/>";
	   }else{
		  return ""; 
	   }
   }
	
	public String getDesSindicato() {
		return desSindicato;
	}

	public void setDesSindicato(String desSindicato) {
		this.desSindicato = desSindicato;
	}

	public String getActaVersion() {
		return actaVersion;
	}

	public void setActaVersion(String actaVersion) {
		this.actaVersion = actaVersion;
	}

	public String getDniSustituido() {
		return dniSustituido;
	}

	public void setDniSustituido(String dniSustituido) {
		this.dniSustituido = dniSustituido;
	}

	public String getFActu() {
		return fActu;
	}

	public void setFActu(String actu) {
		fActu = actu;
	}

	public String getUsuario() {
		return usuario;
	}

	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}
	public String getActaTerritorio() {
		return actaTerritorio;
	}

	public void setActaTerritorio(String actaTerritorio) {
		this.actaTerritorio = actaTerritorio;
	}
	public String getActaAnyo() {
		return actaAnyo;
	}

	public void setActaAnyo(String actaAnyo) {
		this.actaAnyo = actaAnyo;
	}

	public String getActaNum() {
		return actaNum;
	}

	public void setActaNum(String actaNum) {
		this.actaNum = actaNum;
	}

	public String getCodColegio() {
		return codColegio;
	}

	public void setCodColegio(String codColegio) {
		this.codColegio = codColegio;
	}

	public String getColegio_cast() {
		return colegio_cast;
	}

	public void setColegio_cast(String colegio_cast) {
		this.colegio_cast = colegio_cast;
	}

	public String getColegio_eusk() {
		return colegio_eusk;
	}

	public void setColegio_eusk(String colegio_eusk) {
		this.colegio_eusk = colegio_eusk;
	}

	public String getDniDelegado() {
		return dniDelegado;
	}
	public void setDniDelegado(String dniDelegado) {
		this.dniDelegado = dniDelegado;
	}

	public String getPrimerApellidoDelegado() {
		return primerApellidoDelegado;
	}

	public void setPrimerApellidoDelegado(String primerApellidoDelegado) {
		this.primerApellidoDelegado = primerApellidoDelegado;
	}

	public String getSegundoApellidoDelegado() {
		return segundoApellidoDelegado;
	}

	public void setSegundoApellidoDelegado(String segundoApellidoDelegado) {
		this.segundoApellidoDelegado = segundoApellidoDelegado;
	}

	public String getNombreDelegado() {
		return nombreDelegado;
	}

	public void setNombreDelegado(String nombreDelegado) {
		this.nombreDelegado = nombreDelegado;
	}

	public String getSexoDelegado() {
		return sexoDelegado;
	}

	public void setSexoDelegado(String sexoDelegado) {
		this.sexoDelegado = sexoDelegado;
	}

	public String getCodSindicato() {
		return codSindicato;
	}

	public void setCodSindicato(String codSindicato) {
		this.codSindicato = codSindicato;
	}

	public String getSindicato_cast() {
		return sindicato_cast;
	}

	public void setSindicato_cast(String sindicato_cast) {
		this.sindicato_cast = sindicato_cast;
	}
	public String getSindicato_eusk() {
		return sindicato_eusk;
	}

	public void setSindicato_eusk(String sindicato_eusk) {
		this.sindicato_eusk = sindicato_eusk;
	}

	public String getFechaAlta() {
		return fechaAlta;
	}

	public void setFechaAlta(String fechaAlta) {
		this.fechaAlta = fechaAlta;
	}

	public String getFechaBaja() {
		return fechaBaja;
	}

	public void setFechaBaja(String fechaBaja) {
		this.fechaBaja = fechaBaja;
	}

	public String getCodBaja() {
		return codBaja;
	}

	public void setCodBaja(String codBaja) {
		this.codBaja = codBaja;
	}

	public String getBaja_cast() {
		return baja_cast;
	}

	public void setBaja_cast(String baja_cast) {
		this.baja_cast = baja_cast;
	}

	public String getBaja_Eusk() {
		return baja_Eusk;
	}

	public void setBaja_Eusk(String baja_Eusk) {
		this.baja_Eusk = baja_Eusk;
	}

	public String getDniSustituto() {
		return dniSustituto;
	}
	
	public String getBajaTrueFalse() {
		if(StringUtils.isEmpty(this.fechaBaja)){
			return "false";
		}else{
			return "true";			
		}
	}

	public void setDniSustituto(String dniSustituto) {
		this.dniSustituto = dniSustituto;
	}
	
	public String getSexoDelegadoTxt(){
		if(StringUtils.isNotEmpty(this.getIdioma())){
			try {
				if(W83aClsConstantes.CONSTANTE_VARON.equals(this.sexoDelegado)){
					return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.hombre",(String)this.getIdioma());
				}else if(W83aClsConstantes.CONSTANTE_MUJER.equals(this.sexoDelegado)){
						return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.herramientas.mujer",(String)this.getIdioma());
				}
			} catch (Q70GestorMensajesException e) {
				// TODO Auto-generated catch block
				W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
			}
		}
		return "";
	}
	

	public boolean equals(Object bean){
		if(bean instanceof W83aDelegadosBean ){
			W83aDelegadosBean delegadoAux = (W83aDelegadosBean)bean;
			if(null!=this.getDniDelegado()
					&&null!=delegadoAux.getDniDelegado()){
				if(this.getDniDelegado().equals(delegadoAux.getDniDelegado())){
					return true;
				}
			}
			return false;
		}else{
			return bean.equals(this);
		}
	}
	

	public Object rowToBean(Object o, Object otrosValores) throws SQLException, Q70GestorMensajesException {
		// TODO Auto-generated method stub
		ResultSet rs= (ResultSet)o;//NOPMD
		
		if(null!= otrosValores && 
				"delegado".equals(otrosValores)){			
			this.actaNum = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.acta);
			this.actaAnyo = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.anyoActa);
			this.primerApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.apellido1);
			this.segundoApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.apellido2);
			this.codBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.baja);
			this.codColegio = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.codColegio);
			this.codSindicato = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.codSindicato);
			this.dniDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.dni);
			this.dniSustituto = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.dniSustituto);
			this.fechaAlta = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaAlta);
			this.fechaBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaBaja);
			this.fActu = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaMod);
			this.nombreDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.nombre);
			this.sexoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.sexo);
			this.actaTerritorio = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.territorioActa);
			this.usuario = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.usuario);
			this.actaVersion = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.versionActa);			
		}else if(null!= otrosValores && 
					"detalleDelegado".equals(otrosValores)){			
			this.actaNum = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.acta);
			this.actaAnyo = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.anyoActa);
			this.primerApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.apellido1);
			this.segundoApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.apellido2);
			this.codBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.baja);
			this.codColegio = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.codColegio);
			if("0".equals(codColegio)){
				this.codColegio = "T";
			}else{
				this.codColegio = "E";				
			}
			this.codSindicato = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.codSindicato);
			this.dniDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.dni);
			this.dniSustituto = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.dniSustituto);
			this.fechaAlta = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaAlta);
			this.fechaBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaBaja);
			this.fActu = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.fechaMod);
			this.nombreDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.nombre);
			this.sexoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.sexo);
			this.actaTerritorio = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.territorioActa);
			this.usuario = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.usuario);
			this.actaVersion = W83aDataBase.getStringFromRS(rs, W83aDelegadosBD.versionActa);
			this.desSindicato = W83aDataBase.getStringFromRS(rs, W83aSindicatosBD.descSindicatoCast);
			this.siglas = W83aDataBase.getStringFromRS(rs, W83aSindicatosBD.siglas);
		}else if(null!=otrosValores){
			this.actaTerritorio = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.actaTerritorio);
			this.actaAnyo = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.actaAnyo);
			this.actaNum = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.actaNum);
			this.actaVersion = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.versionacta);
			this.codColegio = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.codColegio);
			if("0".equals(codColegio)){
				this.codColegioLetra = "T";
			}else{
				this.codColegioLetra = "E";				
			}
			this.colegio_cast = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.colegio_cast);
			this.colegio_eusk = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.colegio_eusk);
			this.dniDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.dniDelegado);
			this.primerApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.primerApellidoDelegado);
			this.segundoApellidoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.segundoApellidoDelegado);
			this.nombreDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.nombreDelegado);
			this.sexoDelegado = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.sexoDelegado);
			this.codSindicato = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.codSindicato);
			this.sindicato_cast = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.sindicato_cast);
			this.sindicato_eusk = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.sindicato_eusk);
			this.siglas = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.siglas);
			this.fechaAlta = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.fechaAlta);
			this.fechaBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.fechaBaja);
			this.codBaja = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.codBaja);
			this.baja_cast = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.baja_cast);
			this.baja_Eusk = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.baja_Eusk);
			this.dniSustituto = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.dniSustituto);
			this.fActu = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.fActu);
			this.usuario = W83aDataBase.getStringFromRS(rs, W83aDelegadosIncidenciasVistaBD.usuario);
			
			this.idioma = (String)otrosValores;
		}
		
		return this;
	}	
}
